#!/usr/bin/python2

import sys
import os, shutil
import curses
import curses.textpad
import urllib
import timeoutsocket
import locale
import time
import string, StringIO
import re
import sha
import textwrap

# 3rd party modules
import feedparser
import html2text


import threading

# use_default_colors was added in python 2.4
# if we don't have it, don't bother with colors
if not hasattr(curses, "use_default_colors"):
    try:
        import curses_extra
        curses.use_default_colors = curses_extra.use_default_colors
        BGCOLOR = -1
        USE_COLORS = 1
    except:
        def use_default_colors():
            pass
        BGCOLOR = curses.COLOR_WHITE
        USE_COLORS = 0
        curses.use_default_colors = use_default_colors
else:
    BGCOLOR = -1
    USE_COLORS = 1

reload(sys)
sys.setdefaultencoding('utf-8')
#lang, encoding = locale.getdefaultlocale()

timeoutsocket.setDefaultSocketTimeout(20)


BROWSER = r"lynx %s"
COLOR = {}
VERSION = "0.9.4"
RCDIR = "%s/.goodnews-%s" % (os.getenv("HOME"), VERSION)

OS = sys.platform
NULL = None

# Set the User-Agent string
USER_AGENT = "Goodnews/%s (%s)" % (VERSION, OS)

class GoodnewsURLopener(urllib.FancyURLopener):
    version = USER_AGENT
urllib._urlopener = GoodnewsURLopener()


CMD_SLOTS_COLUMNS =6 
CMD_SLOTS = (CMD_SLOTS_COLUMNS * 2) - 1

SHOW_BOZO = 0
CURSOR_ON = 1

cur_cmd_grp = []
keybinding = {}
first_ptr = []
first_scr_ptr = 0

class FeedMenu:

    def __init__(self):
        self.first_scr_ptr = 0
        self.items = {}
        self.sorted = []
        

class Feed:
    def __init__(self):
        self.id = ""
        self.feedurl = ""
        self.feed = ""
        self.feed_data = ""
        self.title = ""
        self.link = ""
        self.description = ""
        self.lastmodified = ""
        self.lasthttpstatus = 0
        self.highlighted = None
        
        self.items = {}
        self.sorted = []
        
        self.first_scr_ptr = 0
        
        self.problem = 0
        self.override = ""
        self.original = ""

        self.categories = ()

        self.bozo = 0

class NewsItem:
    def __init__(self):
        self.readstatus = 0
        self.title = ""
        self.link = ""
        self.description = ""
        self.id = ""

        self.page_lines = []
        self.page_showed = 0
        self.total_pages = 0

def ex_entry_field(stdscr, default=""):

    LINES, COLS = stdscr.getmaxyx()

    
    win = curses.newwin(3, COLS -4)

    win.mvwin((LINES//2) - 2, 2)
    win.box()
    win.refresh()
    
    text_win = curses.newwin(1,COLS - 6)
    text_win.mvwin((LINES//2) - 2 + 1, 3)
    
    textpad  = curses.textpad.Textbox(text_win)

    if default:
        text_win.addstr(0, 0, default)
    
    #curses.echo()
    #curses.curs_set(1)
    
    t = textpad.edit()

    #curses.curs_set(0)
    
    return t
    

def InitCurses():
    
    stdscr = curses.initscr()

    stdscr.keypad(1)
    curses.cbreak()
    curses.noecho()

    stdscr.clear()

    
    stdscr.refresh()
    LINES, COLS = stdscr.getmaxyx()

    if USE_COLORS:
        
        curses.start_color();

        #default color for fg/bg set to -1
        curses.use_default_colors()

        # FIXME: find a pleasing color combo
        curses.init_pair (10, 1, BGCOLOR); #/* red */
        curses.init_pair (11, 2, BGCOLOR); #/* green */
        curses.init_pair (12, 3, BGCOLOR); #/* orange */
        curses.init_pair (13, 4, BGCOLOR); #/* blue */
        curses.init_pair (14, 5, BGCOLOR); #/* magenta */
        curses.init_pair (15, 6, BGCOLOR); #/* cyan */
        curses.init_pair (16, 7, BGCOLOR); #* gray */
        curses.init_pair (17, curses.COLOR_YELLOW, curses.COLOR_BLUE)
        curses.init_pair (18, curses.COLOR_WHITE, curses.COLOR_BLUE)

    return stdscr
    
def draw_status(stdscr, txt, delay=0):
    #FIXME: center all messages in status
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS -1
    stdscr.attron (curses.A_BOLD)

    # clear
    stdscr.addstr(LINES-3, 0, ' '*COLS)

    if USE_COLORS:
        stdscr.addnstr (LINES-3, 1, txt, COLS-2, curses.color_pair(10));
    else:
        stdscr.addnstr (LINES-3, 1, txt, COLS-2);

    stdscr.attroff (curses.A_BOLD);
    stdscr.refresh()
    
    if delay:
        time.sleep(delay)





    

def draw_header (stdscr, filterstring="", use_colors=USE_COLORS):
    LINES, COLS = stdscr.getmaxyx()
    #stdscr.attron (curses.A_STANDOUT)

    headerline = ""
    
    attrs = curses.A_BOLD
    
    if use_colors:
        attrs = curses.color_pair(17)|curses.A_BOLD

    stdscr.addstr(0, 0, ' '*COLS, attrs);
    stdscr.addstr(0, 1, "* %s" % USER_AGENT, attrs)

    if filterstring:
        stdscr.addstr(0, COLS-len(filterstring)-1, filterstring, attrs);

    if SHOW_BOZO:
        stdscr.addstr(0, len(USER_AGENT) + 10, "*bozo*", attrs)
        
    stdscr.refresh()


def draw_footer(stdscr, cur_grp, bindings):
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 1
    slots = CMD_SLOTS_COLUMNS
            
    grp = cur_grp[:]

    
    slotspace = columns // slots

    # clear the space
    stdscr.addstr(LINES-1, 0, ' '* columns)
    stdscr.addstr(LINES-2, 0, ' '* columns)

    # draw new
    for y in (LINES - 2, LINES - 1):
        for x in range(slots):

            if not grp:
                break
            
            i = grp.pop(0)
                
            if bindings.has_key(i):
                outstr = bindings[i]
                outstr = outstr.split('_')[-1]
            elif i == '^O':
                outstr = "morecmds"
            else:
                outstr = "no cmd"
            
            #outstr = str(slotspace) + " Cmd Here"

            stdscr.attron (curses.A_STANDOUT)
            stdscr.addstr(y, x * slotspace, repr(i))
            stdscr.attroff (curses.A_STANDOUT)
            
            if len(outstr) < slotspace - 5:
                padding = (slotspace - 5) - len(outstr)
                outstr += " "* padding
            else:
                outstr = outstr[:slotspace -5]
        
            stdscr.addstr(y, (x * slotspace) + len(repr(i)) + 1, outstr)


        

def dump_traceback(stdscr, s):
    stdscr.move(2,0)
    stdscr.addstr(s)
    draw_status(stdscr, "****** CRASH CRASH CRASH ******\n****** Press Any Key To Continue ******", 0)
    stdscr.getch()



## KEYBINDINGS ##

def keybind_morecmds(stdscr, **args):
    global cur_cmd_grp

    if args.has_key('bindings'):
        bindings = args['bindings']
    else:
        return

    
    slots = CMD_SLOTS
    
    kys = bindings.keys()
    kys.sort()
    k = []

    for j in kys:
        if not type(j) == type(0):
            k.append(j)


    i = k.index(cur_cmd_grp[-2])

    if not cur_cmd_grp[-1] == '^O' or cur_cmd_grp[-2] == k[-1]:
        i = -1

    if len(k) > CMD_SLOTS:
        cur_cmd_grp = k[i + 1:i + 1 + slots]
        cur_cmd_grp.append('^O')
    else:
        cur_cmd_grp = k[:slots + 1]        

        
    draw_footer(stdscr, cur_cmd_grp, bindings)


def keybind_cursor(stdscr, **args):
    global CURSOR_ON

    CURSOR_ON = not CURSOR_ON

    if CURSOR_ON:
        curses.curs_set(0)
    else:
        curses.curs_set(1)


def keybind_bozo(stdscr, **args):
    global SHOW_BOZO
    
    SHOW_BOZO = not SHOW_BOZO
    
def keybind_quit(scr, **args):
    return 1


def keybind_addfeed(stdscr, **args):
    global highlighted
    
    ptr = add_feed(stdscr, first_ptr)
    if ptr:
        highlighted = first_ptr[-1]
    
        
def keybind_delfeed(stdscr, **args):

    deletion = highlighted

    if deletion == first_ptr[0]:
        keybind_next(stdscr)
    else:
        keybind_prev(stdscr)
    
    first_ptr.remove(deletion)
    

def keybind_allread(stdscr, **args):
    for i in highlighted.items:
        highlighted.items[i].readstatus = 1
    pass

def keybind_browser(stdscr, **args):
    global BROWSER

    draw_status(stdscr, 'Enter a browser command. Example: lynx "%s" (%s is the URL)', 0)
    s = ex_entry_field(stdscr, BROWSER)
    
    if s:
        BROWSER = s
        
def keybind_moveup(stdscr, **args):

    i =  first_ptr.index(highlighted)
    cut = first_ptr.remove(highlighted)
    
    if i > 0:
        i -= 1

    first_ptr.insert(i, highlighted)

def keybind_movedown(stdscr, **args):
    i =  first_ptr.index(highlighted)
    cut = first_ptr.remove(highlighted)
    
    if i < len(first_ptr):
        i += 1

    first_ptr.insert(i, highlighted)

def keybind_feedinfo(stdscr, **args):
    pass

def keybind_reload(stdscr, **args):
    update_feed(stdscr, highlighted)

def keybind_reloadall(stdscr, **args):
    update_all_feeds(stdscr, first_ptr, draw_feeds, highlighted, args['bindings'])


def keybind_urljump (stdscr, **args):
    LINES, COLS = stdscr.getmaxyx()
    if not syscall:
        return
    
    draw_status(stdscr, "Executing: %s ..."% syscall[:COLS-7], 0)
    ret = os.system("%s 2>/dev/null"% syscall)
    if ret:
        draw_status(stdscr, "Error '%i' from browser command..."% ret, 2)

def keybind_urljump2(stdscr, **args):
    pass

def keybind_changefeedname(stdscr, **args):
    pass

def keybind_sortfeeds (stdscr, **args):
    pass

def keybind_pup(stdscr, **args):
    pass

def keybind_pdown(stdscr, **args):
    pass

def keybind_categorize(stdscr, **args):
    pass

def keybind_filter(stdscr, **args):
    pass

def keybind_filtercurrent(stdscr, **args):
    pass

def keybind_nofilter(stdscr, **args):
    pass

def keybind_help(stdscr, **args):
    pass

def keybind_about(stdscr, **args):
    pass

def keybind_next(stdscr, **args):
    global highlighted

    if not first_ptr:
        return
    
    if first_ptr.index(highlighted) < len(first_ptr) -1:
        highlighted = first_ptr[first_ptr.index(highlighted) + 1]


# new test
def keybind_next(stdscr, **args):
    global highlighted, first_scr_ptr

    LINES,COLS = stdscr.getmaxyx()
    maxlines = LINES - 6

    if not first_ptr:
        return

    if first_ptr.index(highlighted) < len(first_ptr) -1:
        highlighted = first_ptr[first_ptr.index(highlighted) + 1]

    if first_ptr.index(highlighted) - first_scr_ptr > (maxlines - 4):
        first_scr_ptr += 1


def keybind_prev(stdscr, **args):
    global highlighted

    if not first_ptr:
        return
    
    if first_ptr.index(highlighted) > 0:
        highlighted = first_ptr[first_ptr.index(highlighted) - 1]

# new test
def keybind_prev(stdscr, **args):
    global highlighted, first_scr_ptr
    
    if not first_ptr:
        return
    
    if first_ptr.index(highlighted) > 0:
        highlighted = first_ptr[first_ptr.index(highlighted) - 1]

    if (first_ptr.index(highlighted) - first_scr_ptr) < 0:
        first_scr_ptr -= 1
    

def keybind_feed_down(stdscr, **args):
    LINES,COLS = stdscr.getmaxyx()
    maxlines = LINES - 6
    
    if cur_feed.sorted.index(cur_feed.highlighted.id) < len(cur_feed.items) -1 :
        cur_feed.highlighted = cur_feed.items[cur_feed.sorted[cur_feed.sorted.index(cur_feed.highlighted.id) + 1]]

    if (cur_feed.sorted.index(cur_feed.highlighted.id) - cur_feed.first_scr_ptr) > (maxlines - 4):
        cur_feed.first_scr_ptr += 1
        

def keybind_feed_up(stdscr, **args):
    if cur_feed.sorted.index(cur_feed.highlighted.id) > 0:
        cur_feed.highlighted = cur_feed.items[cur_feed.sorted[cur_feed.sorted.index(cur_feed.highlighted.id) - 1]]

    if (cur_feed.sorted.index(cur_feed.highlighted.id) - cur_feed.first_scr_ptr) < 0:
        cur_feed.first_scr_ptr -= 1
    
def keybind_mark_item_read(stdscr, **args):
    cur_feed.highlighted.readstatus = 1
    keybind_feed_down(stdscr)

def keybind_mark_item_unread(stdscr, **args):
    cur_feed.highlighted.readstatus = 0
    keybind_feed_down(stdscr)    

    
def keybind_select(stdscr, **args):
    global cur_cmd_grp
    
    item_keybind = {}

    item_keybind['m'] = 'keybind_allread'
    item_keybind['q'] = 'keybind_quit'
    item_keybind['o'] = 'keybind_urljump'
    item_keybind[curses.KEY_UP] = 'keybind_feed_up'
    item_keybind[curses.KEY_DOWN] = 'keybind_feed_down'


    item_keybind['d'] = 'keybind_mark_item_read'
    item_keybind['u'] = 'keybind_mark_item_unread'
    
    item_keybind['n'] = 'keybind_feed_down'
    item_keybind['p'] = 'keybind_feed_up'

    item_keybind['N'] = 'keybind_next'
    item_keybind['P'] = 'keybind_prev'    
    
    item_keybind['\n'] = 'keybind_feed_select'
    item_keybind[' '] = 'keybind_feed_select'    

    item_keybind['B'] = 'keybind_browser'
    
    if not first_ptr:
        return

    if not highlighted.items:
        draw_status(stdscr, "Warning: No items to show!", 2)
        return
    
    LINES,COLS = stdscr.getmaxyx()
    maxlines = LINES - 6

    highlighted.highlighted = highlighted.items[highlighted.sorted[0]]
    cur = max = 0
    highlighted.first_scr_ptr = 0
    
    for i in highlighted.sorted:
        if cur > maxlines - 4:
            max += 1
        cur += 1            

        if not highlighted.items[i].readstatus:
            highlighted.highlighted = highlighted.items[i]
            highlighted.first_scr_ptr = max
            break

    cur_cmd_grp = setup_cmd_grp(item_keybind)
    
    while 1:
        draw_news(stdscr, highlighted)
        draw_footer(stdscr, cur_cmd_grp, item_keybind)        
        if do_main_cmdloop(stdscr, 0, item_keybind):
            cur_cmd_grp = setup_cmd_grp(args['bindings'])
            break
        

def setup_cmd_grp(bindings):
    
    cmd_grp = []
    
    k = bindings.keys()
    k.sort()

    for j in k:
        if not type(j) == type(0):
            cmd_grp.append(j)
            

    if len(cmd_grp) > CMD_SLOTS:
        grp = cmd_grp[:CMD_SLOTS]
        grp.append('^O')
    else:
        grp = cmd_grp[:CMD_SLOTS + 1]
        
    return grp


def keybind_feed_enter_quit(stdscr, **args):
    while cur_feed.highlighted.id != cur_feed.sorted[-1]:
        keybind_feed_down(stdscr)
        if not cur_feed.highlighted.readstatus:
            return 1
    curses.ungetch('q')

    return 1

def keybind_feed_select(stdscr, **args):
    global cur_cmd_grp, cur_keybind
    
    item_keybind = {}
    
    item_keybind['q'] = 'keybind_quit'
    item_keybind['o'] = 'keybind_urljump'
    item_keybind[curses.KEY_UP] = 'keybind_feed_up'
    item_keybind['p'] = 'keybind_feed_up'
    item_keybind[curses.KEY_DOWN] = 'keybind_feed_down'
    item_keybind['n'] = 'keybind_feed_down'

    item_keybind['\n'] = 'keybind_feed_enter_quit'

    item_keybind[' '] = 'keybind_feed_enter_quit'
    #item_keybind[' '] = 'keybind_feed_next_page'

    item_keybind['B'] = 'keybind_browser'
    
    cur_cmd_grp = setup_cmd_grp(item_keybind)
    
    while 1:
        draw_item(stdscr, cur_feed)
        draw_footer(stdscr, cur_cmd_grp, item_keybind)
        if do_main_cmdloop(stdscr, 0, item_keybind):
            cur_cmd_grp = setup_cmd_grp(args['bindings'])
            break


def do_item_loop(stdscr, item, keybindings):
    while 1:
        stdscr.getch()


def enter_main(stdscr, ptr, keybindings, encoding='latin-1'):
    global highlighted, first_ptr, saved_keybindings, syscall, cur_cmd_grp

    syscall = ""

    saved_keybindings = keybindings
    first_ptr = ptr

    k = keybindings.keys()
    k.sort()

    typeahead = 0;
    
    catfilter = "" #/* Category filter. Must be NULL when not used! */
    filteractivated = 0; #/* Set if filter was activated */

    forceredraw = 0

    first_src_ptr = 0
    if first_ptr:
        highlighted = first_ptr[0]
    else:
        highlighted = None
        
    stdscr.clear()
    
    cur_cmd_grp = setup_cmd_grp(keybindings)
    
    while 1:
        if forceredraw:
            pass
        else:
            stdscr.move(0,0)
            stdscr.clrtobot()

            
        draw_header(stdscr, catfilter)

        if (filteractivated):
            pass

        if typeahead:
            pass
        for cur_ptr in first_ptr:
            pass

        if typeahead:
            pass
        else:
            pass

        draw_feeds(stdscr, first_ptr, highlighted, keybindings)
        draw_footer(stdscr, cur_cmd_grp, keybindings)

        if do_main_cmdloop(stdscr, typeahead, keybindings):
            break


def pretty_print_item(stdscr, description):
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    SNIP = LINES - 13

    tp = []
    for n in description.split("\n"):
        tp.append(n.strip())

    description = "\n".join(tp)
    paragraphs = description.split("\n\n")

    np = []
    for p in paragraphs:
        np.append(textwrap.fill(p, columns))

    outtext = "\n".join(np)
    outlines = outtext.split('\n')


    if len(outlines) > SNIP:
        outlines[SNIP - 1] = outlines[SNIP -1][:-3] + '...'
    
    for line in outlines[:SNIP]:
        if line == '* * *':
            line = "-"*columns

        stdscr.addstr("   " + line + '\n')



def pretty_item_lines(description):

    tp = []
    for n in description.split("\n"):
        tp.append(n.strip())

    description = "\n".join(tp)
    paragraphs = description.split("\n\n")

    np = []
    for p in paragraphs:
        np.append(textwrap.fill(p, columns))

    outtext = "\n".join(np)
    outlines_raw = outtext.split('\n')
    outlines = []
    
    for line in outlines_raw:
        if line == '* * *':
            line = "-"*columns
        outlines.append(line)

    return outlines

  

def test_pretty_print_item(description):
    LINES, COLS = (50, 72)
    columns = COLS - 10
    SNIP = LINES - 13

    tp = []
    for n in description.split("\n"):
        tp.append(n.strip())

    description = "\n".join(tp)
    paragraphs = description.split("\n\n")

    np = []
    for p in paragraphs:
        np.append(textwrap.fill(p, columns) + '\n')

    outtext = "\n".join(np)
    outlines = outtext.split('\n')

    if len(outlines) > SNIP:
        outlines[SNIP - 1] = outlines[SNIP -1][:-3] + '...'
    
    for line in outlines[:SNIP]:
        if line == '* * *':
            line = "-"*columns
            
        sys.stdout.write("   " + line + '\n')
   
        
    
    
def draw_item(stdscr, feed, use_colors=1, encoding='latin-1'):
    ypos = 4
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 6
    
    item = feed.highlighted

    stdscr.move(0,0)
    stdscr.clrtobot()

    draw_header(stdscr, "")

    if feed.description:
        des = feed.description.encode(encoding, 'replace')

        if len(des) > columns:
            des = des[:columns - 5 - 3] + '...'

        stdscr.addstr(2, 1, des, curses.A_BOLD)


    stdscr.move(5,4)
    stdscr.move(5,0)
    pretty_print_item(stdscr, item.title.encode(encoding, 'replace'))
    stdscr.addstr('\n   --\n')

    pretty_print_item(stdscr, item.description.encode(encoding, 'replace'))

    draw_link(stdscr, item)
    
    # ok it's read now
    item.readstatus = 1
    


def draw_link(stdscr, item):
    ypos = 4
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 6

    stdscr.attron(curses.A_BOLD)
    
    syscall = doupdatelink(stdscr, item.link)

    #Show only link
    if len(item.link) > columns:
        stdscr.addstr(maxlines + 2, 1, "-> " + item.link[:columns-5] + "...'")
    else:
        stdscr.addstr(maxlines + 2, 1, "-> " + item.link)
    stdscr.attroff(curses.A_BOLD)



def draw_news(stdscr, feed, use_colors=USE_COLORS, encoding='latin-1'):
    global cur_feed
    
    ypos = 4
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 6
    
    stdscr.move(0,0)
    stdscr.clrtobot()

    draw_header(stdscr, "")

    if use_colors:
        curses.A_STANDOUT = curses.color_pair(18)

    cur_feed = feed

    if not feed.highlighted:
        feed.highlighted = feed.items[feed.sorted[feed.first_scr_ptr]]

    if feed.description:
        des = feed.description.encode(encoding, 'replace')

        if len(des) > columns:
            des = des[:columns-5-3] + '...'
        stdscr.addstr(2, 1, des, curses.A_BOLD)

    for item in feed.sorted[feed.first_scr_ptr:]:
        item = feed.items[item]
        stdscr.move(ypos, 0)
        stdscr.clrtoeol()

        if item.title:
            title = item.title.encode(encoding, 'replace')
        else:
            title = item.link

        if not item.readstatus:
            stdscr.attron(curses.A_BOLD)
            curses.A_STANDOUT = curses.A_STANDOUT|curses.A_BOLD

        if item == feed.highlighted:
            draw_link(stdscr, item)
            
            stdscr.attron(curses.A_STANDOUT)
            stdscr.addstr(ypos, 1, " "* (COLS - 2))
            
        if len(title) > columns:
            stdscr.addstr(ypos, 1, title[:columns] + '...')
        else:
            stdscr.addstr(ypos, 1, title)

        if not item.readstatus:
            stdscr.attroff(curses.A_BOLD)

            if use_colors:
                curses.A_STANDOUT = curses.color_pair(18)
            
        if item == feed.highlighted:
            stdscr.attroff(curses.A_STANDOUT)
        
        ypos += 1
        if ypos > maxlines:
            break

        
def draw_feeds(stdscr, feeds, highlighted='', keybindings={}):
    ypos = 2
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 6

    if USE_COLORS:
        curses.A_STANDOUT = curses.color_pair(18)

    if not feeds:
        outstr = "No items to show. Press 'a' to add feeds"

        center = columns // 2
        cos = len(outstr)// 2

        
        stdscr.addstr(10, center - cos, outstr)
        return
        
    for feed in feeds[first_scr_ptr:]:
        stdscr.move(ypos, 0)
        stdscr.clrtoeol()
        newcount = 0

        for i in feed.items:
            if not feed.items[i].readstatus:
                newcount += 1

        if feed == highlighted:
            draw_link(stdscr, feed)
            stdscr.attron(curses.A_STANDOUT)
            stdscr.addstr(ypos, 1, " " * (COLS-2))
            
        if feed.title:
            title = feed.title
        else:
            title = feed.link

        if feed.bozo and SHOW_BOZO:
            title = "*bozo* " + title
            
        if len(title) > columns:
            stdscr.addstr(ypos, 1, title[:columns] + '...')
        else:
            stdscr.addstr(ypos, 1, title)

        if newcount:
            outstr = "(%i new)" % newcount
            
        else:
            outstr = ""
            
        stdscr.addstr(ypos, COLS - len(outstr) -1, outstr)            
        
            
        if feed == highlighted:
            stdscr.attroff(curses.A_STANDOUT)

        ypos += 1
        if ypos > maxlines:
            break
        

def doupdatelink(stdscr, link):
    global syscall
    try:
        syscall = BROWSER % link
    except TypeError:
        draw_status(stdscr, "Error in browser command!", 1)
        draw_status(stdscr, "'%s' missing %%s?" % BROWSER, 0)

    return syscall

            

def do_main_cmdloop(stdscr, typeahead, keybindings):
    global cur_cmd_grp
    quit = 0


    uiinput = stdscr.getch();

    if (typeahead):
        pass
    else:
        # isn't python just swell,
        # well, just look at this code :-)
        if uiinput < curses.KEY_MIN:
            try:
                uiinput = chr(uiinput)
            except ValueError:
                draw_status(stdscr, repr(repr(uiinput)) + "   ", 0)
                
        if keybindings.has_key(uiinput):
            method = keybindings[uiinput]
            g = globals()

            if g.has_key(method):
                quit = g[method](stdscr, bindings=keybindings)
                if quit:
                    return 1
        else:
            draw_status(stdscr, repr(repr(uiinput)) + "   ", 0)


    if (uiinput == ord('\n')):
	keybind_enter(stdscr)
		
    #/* TAB key is decimal 9. */
    if (uiinput == chr(9) ):
        pass

    #/* ctrl+g clears typeahead. */
    if (uiinput == chr(7) ):
        pass

    #/* ctrl+u clears line. */
    if (uiinput == chr(21) ):
        pass

    # ctrl+o shows next cmd group
    if (uiinput == chr(15) ):
        keybind_morecmds(stdscr, bindings=keybindings)
    
    return 0



class FeedParser:
    def __init__(self, cur_ptr):
        global SHOW_BOZO
        
        new_items = {}
        downloaded_items ={}
        orginal_sort = []
        self.error = ""

        # not really needed since feedparser isn't
        # doing the actual download for the moment
        feedparser.USER_AGENT = USER_AGENT

        rssDocument = feedparser.parse(cur_ptr.feed_data)

        if rssDocument.has_key('bozo') and rssDocument['bozo']:
            SHOW_BOZO = 1
            cur_ptr.bozo = 1
            
        try:
            cur_ptr.title = strip_tags(rssDocument['feed']['title'])
        except:
            cur_ptr.title = "(no title)"

        try:
            cur_ptr.link = rssDocument['feed']['link']
        except:
            cur_ptr.link = ""

        try:
            cur_ptr.description = strip_tags(rssDocument['feed']['description'])
        except:
            cur_ptr.description = ""


        for item in rssDocument['entries']:

            if item.has_key('title'):
                title = item['title']
            else:
                title = "(no title)"
                
            if item.has_key('link'):
                link = item['link']
            else:
                link = ""

            if item.has_key('description'):
                description = item['description']
            else:
                description = "(no description)"

            if item.has_key('id') and not (item['id'] == link):
                id = item['id']
            else:
                id = sha.new(link).hexdigest()

            if link:
                new_item = NewsItem()
                new_item.title = html2text.html2text(title)
                new_item.link  = link
                new_item.description = html2text.html2text(strip_links(description))
                new_item.id = id
            else:
                return

            
            if item.has_key('readstatus'):
                new_item.readstatus = int(item['readstatus'])
            else:
                new_item.readstatus = 0

            
            if new_item.link:
                downloaded_items[new_item.id] = new_item
                if new_item.id not in orginal_sort:
                    orginal_sort.append(new_item.id)


                    
        # remove items no longer in print...
        # FIXME: (add an expirery date function here)
        for i in downloaded_items:
            if cur_ptr.items.has_key(i):
                downloaded_items[i].readstatus = cur_ptr.items[i].readstatus
        cur_ptr.items = downloaded_items


        # FIXME: add datetime to each item
        cur_ptr.sorted = orginal_sort



# to replace all those html &blabla; thingys
def get_unicode_entitydefs():
     import htmlentitydefs
     entitydefs = htmlentitydefs.entitydefs.copy()
     for k,v in entitydefs.items():
         if v.startswith('&#'):
             v = int(v[2:-1])
         else:
             v = ord(v)
         entitydefs[k] = unichr(v)
         
     return entitydefs

def replace_qoutes(txt):
    import htmlentitydefs
    qoutes = re.compile('&.*?;', re.S)
    
    ents = get_unicode_entitydefs()
    all_qoutes = qoutes.findall(txt)
    
    for q in all_qoutes:
        if q[2:-1].isdigit():
            if int(q[2:-1]) == 8211:
                new_chr = '\x2d'
            if int(q[2:-1]) == 8212:
                new_chr = ","
            elif int(q[2:-1]) == 8216:
                new_chr = "'"                
            elif int(q[2:-1]) == 8217:
                new_chr = "'"
            else:
                new_chr = unichr(int(q[2:-1]))
                
            txt = txt.replace(q, new_chr)
            
        elif ents.has_key(q[1:-1]):
            c = ents[q[1:-1]]
            txt = txt.replace(q, c)
    return txt
        

# feeds are html, me don't want that :-)
def strip_tags(txt):
    tags = re.compile('<.*?>', re.S)
    return tags.sub('', txt)

def strip_links(txt):

    if not txt:
        return ''
    
    link = re.compile('</?a.*?>', re.S|re.I)
    img = re.compile('</?img.*?>', re.S|re.I)    
    br = re.compile('<br.*?>', re.S|re.I)
    
    txt = link.sub('', txt)
    txt = img.sub('', txt)
    txt = br.sub('<br>', txt)
    
    return txt

def clean_up_and_exit(func, error):
    global stdscr
    if not error:
        write_it_out(stdscr)

    stdscr.clear()
    stdscr.refresh()
    curses.endwin()

    if not error:
        print "Bye\n"

        sys.exit(0)

    else:
        print "Aborting program execution!"
        print "An internal error occured. Goodnews has quit, no changes has been saved!"
        print "----"
        print "While executing: %s" % func
        print "Error as reported by the system: %s\n" % error
        sys.exit(1)



# slashes in filenames is a problem
def hashurl(url):
    return url.replace('/', '_')


#/* Load config and populate caches. */
def load_state_config(stdscr):
    #FIXME: load_state looks a road kill. 
    global BROWSER, COLOR, keybinding
    
    if not os.path.exists(RCDIR):
        try:
            os.mkdir (RCDIR, 0755)
        except OSError, err:
            clean_up_and_exit ("Creating config directory", err);

    else:
        if not os.path.isdir(RCDIR):
            clean_up_and_exit ("Creating config directory",
                          "A file with the same name exists!")
	

    fname = RCDIR + "/cache" 
        
    if not os.path.exists(fname):
        #/* Create directory. */
        try:
            os.mkdir(fname, 0755)
        except OSError, err:
            clean_up_and_exit ("Creating config directory cache/", err)
    else:
        if not os.path.isdir(fname):
            clean_up_and_exit ("Creating config directory cache",
                          "A file with the same name exists!")


    fname = RCDIR + "/cache-readstatus" 
        
    if not os.path.exists(fname):
        #/* Create directory. */
        try:
            os.mkdir(fname, 0755)
        except OSError, err:
            clean_up_and_exit ("Creating config directory cache/", err)
    else:
        if not os.path.isdir(fname):
            clean_up_and_exit ("Creating config directory cache",
                          "A file with the same name exists!")

        
    
    draw_status (stdscr, "Reading configuration settings...", 0)
	


    # default browser
    fname = RCDIR + "/browser" 

    try:
        BROWSER = open(fname).read().strip()

    except IOError:
        draw_status (stdscr, "Creating new config \"browser\"...", 0)

        try:
            BROWSER = r'lynx %s'
            configfile = open(fname, "w+")
            configfile.write(BROWSER)
            configfile.close()
        except IOError, err:
            clean_up_and_exit ('Create initial configfile "config"', err) #/* Still didn't work? */




    # list of feeds
    fname = RCDIR + "/urls"

    try:
        #configfile = open(fname)
        for line in open(fname).readlines():
            url, custom, cats = line.rstrip().split('|')

            new_ptr = Feed()
            new_ptr.feedurl = url
            new_ptr.override = custom

            first_ptr.append(new_ptr)
            #draw_status(stdscr, repr(new_ptr), 1)
            if cats:
                for c in cats.split(','):
                    categories[c].append(new_ptr)
            
    except IOError:
        draw_status (stdscr, "Creating new configfile urls.", 0);
        try:
            configfile = open (fname, "w+")
            configfile.close()            
        except IOError, err:
            clean_up_and_exit ('Create initial configfile "urls', err); # /* Still didn't work? */

    
    # defaults keybindings 

    #keybinding['n'] = 'keybind_next'
    keybinding['n'] = 'keybind_next'
    keybinding['p'] = 'keybind_prev'
    keybinding['q'] = 'keybind_quit'
    keybinding['a'] = 'keybind_addfeed'
    keybinding['D'] = 'keybind_delfeed'
    keybinding['m'] = 'keybind_allread'
    keybinding['B'] = 'keybind_browser'
    keybinding['P'] = 'keybind_moveup'
    keybinding['N'] = 'keybind_movedown'
    #keybinding['i'] = 'keybind_feedinfo'
    keybinding['r'] = 'keybind_reload'
    keybinding['R'] = 'keybind_reloadall'
    keybinding['o'] = 'keybind_urljump'
    #keybinding['O'] = 'keybind_urljump2'
    #keybinding['c'] = 'keybind_changefeedname'
    #keybinding['s'] = 'keybind_sortfeeds'
    #keybinding['b'] = 'keybind_pup'
    #keybinding[' '] = 'keybind_pdown'
    keybinding[' '] = 'keybind_select'    
    #keybinding['C'] = 'keybind_cursor'
    #keybinding['f'] = 'keybind_filter'
    #keybinding['g'] = 'keybind_filtercurrent'
    #keybinding['F'] = 'keybind_nofilter'
    #keybinding['h'] = 'keybind_help'
    #keybinding['A'] = 'keybind_about'

    keybinding['*'] = 'keybind_bozo'
    
    # other keybindings
    #keybinding[curses.KEY_LEFT] = 'keybind_prev'
    #keybinding[curses.KEY_RIGHT] = 'keybind_next'
    keybinding[curses.KEY_UP] = 'keybind_prev'
    keybinding[curses.KEY_DOWN] = 'keybind_next'
    keybinding[curses.KEY_NPAGE] = 'keybind_pdown'
    keybinding[curses.KEY_PPAGE] = 'keybind_pup'
    keybinding[curses.KEY_RESIZE] = 'keybind_resize'
    
    #keybinding['\t'] = 'keybind_tab'
    keybinding['\n'] = 'keybind_select'
    # ctrl-g
    #keybinding['\x07'] = 'keybind_ctrlg'
    # ctrl-u
    #keybinding['\x15'] = 'keybind_ctrlu'
    #keybinding['^O'] = 'keybind_morecmds'
    

    # FIXME: read keybindings from file here
	
    #/***********************
    #* COLOR suppport code *
    #***********************/
	
    COLOR["changed"] = 0
    COLOR["newitems"] = 5
    COLOR["newitemsbold"] = 0
    COLOR["urljump"] = 4
    COLOR["urljumpbold"] = 0
    
    use_colors = USE_COLORS
    
    fname = RCDIR + "/colors"
    try:
        #configfile = open(fname)
        for line in open(fname).readline():
            if line[0] == "#":
                continue

            line = line.strip().split(':')

            if line[0] == "enabled":
                use_colors = int(line[1])
                
            elif line[0] == "new item":
                COLOR["newitems"] = int(line[1])
                if COLOR["newitems"] > 7:
                    COLOR["newitemsbold"] = 1
            elif line[0] == "goto url":                
                COLOR['urljump'] = int(line[1])
                if COLOR['urljump'] > 7:
                    COLOR['urljumlbold'] = 1
    except IOError:
        #/* Set color configfile update flag. */
        COLOR["changed"] = 1


    #FIXME: read color config from file here
    



class UpdateFeedThread(threading.Thread):

    def __init__(self,tlock, stdscr, cur_ptr, first_ptr, draw_feeds, highlighted, keybindings):

        threading.Thread.__init__(self)

        self.stdscr = stdscr
        self.cur_ptr = cur_ptr
        self.first_ptr = first_ptr
        self.draw_feeds = draw_feeds
        self.tlock = tlock
        self.highlighted = ''

    def draw_status_tlock(self, stdscr, txt, delay=0):
        self.tlock.acquire()            
        draw_status(stdscr, txt, delay)
        self.tlock.release()            
        
    def run(self):
        try:
            self.real_run()

            draw_feeds(self.stdscr, self.first_ptr, self.highlighted)
            draw_footer(self.stdscr, cur_cmd_grp, keybindings)
            stdscr.refresh()

        except:
            pass

        
    def real_run(self):

        if not self.cur_ptr:
            return 0
        LINES, COLS = stdscr.getmaxyx()

        self.draw_status_tlock(stdscr, "Downloading " + self.cur_ptr.feedurl[:COLS], 0)

        try:
            self.cur_ptr.feed = urllib.urlopen(self.cur_ptr.feedurl)
            self.cur_ptr.feed_data = self.cur_ptr.feed.read()
            self.cur_ptr.feed = StringIO.StringIO(self.cur_ptr.feed_data)

        except IOError, err:
            self.draw_status_tlock(stdscr, "Downloading: "+err[1][1], 1)
            return 2
        except timeoutsocket.Timeout, err:
            self.draw_status_tlock(stdscr,str(err), 1)
            return 1

        if not self.cur_ptr.title:
            self.cur_ptr.title = self.cur_ptr.feedurl
        if not self.cur_ptr.link:
            self.cur_ptr.link = self.cur_ptr.feedurl

        if not self.cur_ptr.feed:
            return 0

        self.draw_status_tlock(stdscr, "Parsing " + self.cur_ptr.feedurl[:COLS], 0)
        xml = FeedParser(self.cur_ptr)
        if self.cur_ptr.bozo:
            self.draw_status_tlock(stdscr, "Warning: bozo XML! Maybe not a RSS feed?", 2)


        #Don't mess up highlight
        self.cur_ptr.highlighted = None

        #if cur_ptr.feed:
        #    del(cur_ptr.feed)

        return 1



    
        
# Update feed from server.
def update_feed(stdscr, cur_ptr):

    if not cur_ptr:
        return 0
    LINES, COLS = stdscr.getmaxyx()

    draw_status(stdscr, "Downloading " + cur_ptr.feedurl[:COLS], 0)

    try:
        cur_ptr.feed = urllib.urlopen(cur_ptr.feedurl)
        cur_ptr.feed_data = cur_ptr.feed.read()
        cur_ptr.feed = StringIO.StringIO(cur_ptr.feed_data)
        
    except IOError, err:
        draw_status(stdscr, "Downloading: "+err[1][1], 1)
        return 2
    except timeoutsocket.Timeout, err:
        draw_status(stdscr,str(err), 1)
        return 1

    if not cur_ptr.title:
        cur_ptr.title = cur_ptr.feedurl
    if not cur_ptr.link:
        cur_ptr.link = cur_ptr.feedurl
	
    if not cur_ptr.feed:
        return 0

    draw_status(stdscr, "Parsing " + cur_ptr.feedurl[:COLS], 0)
    xml = FeedParser(cur_ptr)
    if cur_ptr.bozo:
        draw_status(stdscr, "Warning: bozo XML! Maybe not a RSS feed?", 2)


    #Don't mess up highlight
    cur_ptr.highlighted = None
    
    #if cur_ptr.feed:
    #    del(cur_ptr.feed)

    return 1




def update_all_feeds(stdscr, first_ptr, draw_feeds=None, highlighted='', keybindings={}):
    for cur_ptr in tuple(first_ptr):
        if update_feed(stdscr, cur_ptr) == 2:
            break

        if draw_feeds:
            draw_feeds(stdscr, first_ptr, highlighted, keybindings)
            stdscr.refresh()



def update_all_feeds(stdscr, first_ptr, draw_feeds=None, highlighted='', keybindings={}):
    tlock = threading.Lock()

    threads = []

    # before we begin, redraw the feeds without a highlight bar
    draw_feeds(stdscr, first_ptr, highlighted='')

    for cur_ptr in tuple(first_ptr):

        threads.append(UpdateFeedThread(tlock, stdscr, cur_ptr, first_ptr, draw_feeds, highlighted, keybindings))
        
        threads[-1].setDaemon(0)
        threads[-1].start()


    # don't return until all threads are finished,
    # or else we risk all kind of bad things :-) 
    while threading.activeCount() > 1:
        pass



#/* Load feed from disk. And call update_feed if neccessary. */
def load_feed(stdscr,cur_ptr):

    hashme = hashurl(cur_ptr.feedurl)
    fname = RCDIR + "/cache/%s" % (hashme)

    try:
        cache = open(fname)
    except IOError:
        tmp = "Cache for %s is toast. Reloading from server..." % cur_ptr.feedurl
        draw_status (stdscr, tmp, 0);
        if not update_feed(stdscr, cur_ptr):
            first_ptr.remove(cur_ptr)

        return 0

	
    #/* Read complete cachefile. */
    cur_ptr.feed = cache
    cur_ptr.feed_data = cur_ptr.feed.read()
    cur_ptr.feed = StringIO.StringIO(cur_ptr.feed_data)    
    
    #/* After loading FeedParserize the mess. */
    xml = FeedParser(cur_ptr)
    cache.close()

    if cur_ptr.bozo:
        draw_status(stdscr, "Warning: bozo XML! Maybe not a RSS feed?", 2)

    
    # get readstatus
    fname = RCDIR + "/cache-readstatus/%s" % (hashme)
    cache_readstatus = open(fname)
    for i in cache_readstatus.readlines():
        id, status = i.split('\t')
        if cur_ptr.items.has_key(id):
            cur_ptr.items[id].readstatus = int(status)
            
    #draw_status(stdscr, cur_ptr.item_link, 1)

    
    
    return 1


class LoadFeedThread(threading.Thread):

    def __init__(self, tlock, stdscr, cur_ptr):
        threading.Thread.__init__(self)

        self.tlock = tlock
        self.stdscr = stdscr
        self.cur_ptr = cur_ptr


    def draw_status_tlock(self, stdscr, txt, delay=0):
        self.tlock.acquire()            
        draw_status(stdscr, txt, delay)
        self.tlock.release()            
        
    def run(self):
        try:
            self.real_run()
        except:
            pass

    def real_run(self):

        tmp = "Loading cache for %s..." % self.cur_ptr.feedurl
        self.draw_status_tlock(stdscr, tmp, 0)        

        hashme = hashurl(self.cur_ptr.feedurl)
        fname = RCDIR + "/cache/%s" % (hashme)

        try:
            cache = open(fname)
        except IOError:
            tmp = "Cache for %s is toast. Reloading from server..." % self.cur_ptr.feedurl
            self.draw_status_tlock(self.stdscr, tmp, 0);
            if not update_feed(self.stdscr, self.cur_ptr):
                first_ptr.remove(self.cur_ptr)

            return 0


        #/* Read complete cachefile. */
        self.cur_ptr.feed = cache
        self.cur_ptr.feed_data = self.cur_ptr.feed.read()
        self.cur_ptr.feed = StringIO.StringIO(self.cur_ptr.feed_data)    

        #/* After loading FeedParserize the mess. */
        xml = FeedParser(self.cur_ptr)
        cache.close()

        if self.cur_ptr.bozo:
            self.draw_status_tlock(self.stdscr, "Warning: bozo XML! Maybe not a RSS feed?", 2)


        # get readstatus
        fname = RCDIR + "/cache-readstatus/%s" % (hashme)
        cache_readstatus = open(fname)
        for i in cache_readstatus.readlines():
            id, status = i.split('\t')
            if self.cur_ptr.items.has_key(id):
                self.cur_ptr.items[id].readstatus = int(status)


        return 1


def load_all_feeds(stdscr):
    # work on a copy of first_ptr
    for cur_ptr in tuple(first_ptr):
        tmp = "Loading cache for %s..." % cur_ptr.feedurl
        draw_status(stdscr, tmp, 0)
        load_feed(stdscr, cur_ptr)



"""
# threaded version
def load_all_feeds(stdscr):
    tlock = threading.Lock()

    threads = []

    for cur_ptr in tuple(first_ptr):
        threads.append(LoadFeedThread(tlock, stdscr, cur_ptr))
        threads[-1].setDaemon(0)
        threads[-1].start()

    # don't return until all threads are finished,
    # or else we risk all kind of bad things :-) 
    while threading.activeCount() > 1:
        pass

"""



# write config and cache to disk
def write_it_out(stdscr):
    global BROWSER
    
    #FIXME: add feature to save each cache any time
    #FIXME: write cache to file more often, not only on exit
    #FIXME: only write when things have changed
    draw_status(stdscr, "Saving settings...", 0)

    fname = RCDIR + "/browser"
    try:
        configfile = open (fname, "w")
    
        configfile.write(BROWSER)
        configfile.close()

    except IOError, err:
        clean_up_and_exit ("Save settings (browser)", err)

    
    fname = RCDIR + "/urls"
    if os.path.isfile(fname):
        shutil.copyfile(fname, fname + ".bak")

    try:
        configfile = open(fname, "w+")
    except IOError, errno:
        clean_up_and_exit ("Save settings (urls)", errno)

    for cur_ptr in first_ptr:
        configfile.write(cur_ptr.feedurl)
        configfile.write("|")
        if cur_ptr.override:
            configfile.write(cur_ptr.title)
        configfile.write("|")
        if cur_ptr.categories:
            configfile.write(string.join(cur_ptr.categories, ","))
        configfile.write('\n')# /* Add newline character. */
		
    configfile.close()


    #* Write cache.
    for cur_ptr in first_ptr:

        hashme = hashurl(cur_ptr.feedurl);
        fname = RCDIR + "/cache/%s" % (hashme)

        cache = open(fname, "w+")
            
        cache.write(cur_ptr.feed_data)
        cache.close()


    #* Write cache-readstatus.
    for cur_ptr in first_ptr:

        hashme = hashurl(cur_ptr.feedurl);
        fname = RCDIR + "/cache-readstatus/%s" % (hashme)

        cache = open(fname, "w+")

        for item_link in cur_ptr.sorted:
            cache.write(item_link + '\t')
            cache.write(str(cur_ptr.items[item_link].readstatus))
            cache.write('\n')

        cache.close()



	
    #/* Write color configfile if needed, */
    # FIXME: color handling is ugly please remove or fix
    if COLOR['changed']:
        fname = RCDIR + "/colors"
        
        configfile = open(fname, "w+")

        configfile.write("# Goodnews color definitons\n")
        configfile.write("# black:0\n")
        configfile.write("# red:1\n")
        configfile.write("# green:2\n")
        configfile.write("# orange:3\n")
        configfile.write("# blue:4\n")
        configfile.write("# magenta(tm):5\n")
        configfile.write("# cyan:6\n")
        configfile.write("# gray:7\n")
        configfile.write("# brightred:9\n")
        configfile.write("# brightgreen:10\n")
        configfile.write("# yellow:11\n")
        configfile.write("# brightblue:12\n")
        configfile.write("# brightmagenta:13\n")
        configfile.write("# brightcyan:14\n")
        configfile.write("# white:15\n")
        configfile.write("enabled:%d\n" % USE_COLORS)
        configfile.write("new item:%d\n"% COLOR['newitems'])
        configfile.write("goto url:%d\n"% COLOR['urljump'])
				
        configfile.close()
	
    return


def off_we_go(stdscr, first_ptr, keybinding, encoding):

    while 1:
        try:
            enter_main(stdscr, first_ptr, keybinding)
            break
        except KeyboardInterrupt:
            break
        except SystemExit:
            break
        except:
            import traceback, StringIO, sys
            s = StringIO.StringIO()
            sys.last_type = sys.exc_type
            sys.last_value = sys.exc_value
            sys.last_traceback = sys.exc_traceback.tb_next
            traceback.print_exception(sys.last_type, sys.last_value, sys.last_traceback, file=s)

            dump_traceback(stdscr, s.getvalue())
        

def set_default_browser(browser):
    global BROWSER
    BROWSER = browser

def add_feed(stdscr, first_ptr):
    LINES, COLS = stdscr.getmaxyx()

    draw_status(stdscr, "Enter URL of the feed you want to add. Blank line to abort.", 0);

    url = ex_entry_field(stdscr)
    
    if not url:
        return 0
	
    #FIXME: do more url checking here
    if not url.startswith("http://"):
        return 0

    new_ptr = Feed()
    new_ptr.feedurl = url
    first_ptr.append(new_ptr)
    
    # download it
    update_feed (stdscr, new_ptr)

    return 1




if __name__ == '__main__':

    #FIXME: argv checking
    
    stdscr = InitCurses();

    try:
        # load configs and caches
        load_state_config(stdscr);

        load_all_feeds(stdscr);        
        enter_main(stdscr, first_ptr, keybinding)

    except KeyboardInterrupt:
        pass
    except SystemExit:
        pass
    except:
        import traceback, StringIO, sys
        s = StringIO.StringIO()
        sys.last_type = sys.exc_type
        sys.last_value = sys.exc_value
        sys.last_traceback = sys.exc_traceback.tb_next
        traceback.print_exception(sys.last_type, sys.last_value, sys.last_traceback, file=s)
        
        dump_traceback(stdscr, s.getvalue())
        

    #off_we_go(stdscr, first_ptr, keybinding, encoding)
    clean_up_and_exit("","")
