
import ConfigParser
import StringIO
import os, sys, tempfile, shutil
from version import version

config_file = "goodnewsrc"

valid_encodings = ('utf-8',
                   'utf8',
                   'latin1',
                   'latin-1',
                   'iso-8859-1',
                   'iso88591')
                   
                   
                   

default_config = """


[General]

HomeDir = %(home)s
Version = %(_version)s
; ConfigDir = %%(HomeDir)s/.goodnews-%%(Version)s/



; Browser command to run to open urls
Browser = lynx %%%%s

; How long to wait for a response when connecting a server
SocketTimeout = 20

; Config
ConfigDir = %%(HomeDir)s/.goodnews-%%(Version)s
ConfigFileName = goodnewsrc
DefaultConfigFile = %%(ConfigDir)s/%%(ConfigFileName)s

; Directory to store goodnews' cache on disk
CacheDir = %%(ConfigDir)s/cache

; How often to safe the cache to disk
; exit=1, load=2, read=3
; CacheSave = exit
CacheSave = 1

; How often to safe read status to disk
; exit=1, feed=2, read=3
; ReadSave = feed
ReadSave = 1

; Only use 'latin-1', 'iso-8859-1', or 'utf-8' 
DefaultEncoding = utf-8

; Show the bozo flag for each badly formed feed
ShowBozo = 0


[Colors]

[Keybindings]

[Feeds]


""" % {'home': os.environ['HOME'],
       '_version': version}


class Config:

    def __init__(self, file=''):

        # load user settings        
        _defaults = StringIO.StringIO(default_config)

        # load default values
        self.config = ConfigParser.SafeConfigParser()
        self.config.readfp(_defaults)

        # get the config file
        if not file:
            self.file = self._search_for_config()
        else:
            self.file = file

        if not os.path.exists(self.file):
            print >> sys.stderr, "Warning config file '%s' doesn't exists" % file
        # load user settings
        self.config.read(self.file)


    def _search_for_config(self):

        config = self._get('General', 'ConfigFileName')
        
        locations = (os.environ['HOME'] + '/.' + config,
                     os.environ['HOME'] + '/' + config,
                     self._get('General', 'DefaultConfigFile'))

        for loc in locations:
            print loc
            if os.path.exists(loc):
                print "exists", loc
                self._set('General', 'ConfigFile', loc)
                return loc

        # fallback
        file = self._get('General', 'DefaultConfigFile')
        self._set('General', 'ConfigFile', file)
        return file


    def _get(self, section, option):
        return self.config.get(section, option).lower()

        
    def _set(self, section, option,value):
        self.config.set(section, option, value)

    def write(self):
        tempfd, tempfname = tempfile.mkstemp(prefix='goodnews-')
        print tempfname
        fp = os.fdopen(tempfd, 'w')
        self.config.remove_section('System')
        self.config.write(fp)
        fp.close()
        shutil.move(tempfname, self.file)


    def get_feeds(self):
        try:
            feeds = dict(self.config.items('Feeds'))
            feed_keys = feeds.keys()
            feed_keys.sort()

            urls = [feeds[k] for k in feed_keys]
            
        except ConfigParser.NoSectionError:
            urls = []

        return urls
            
    def add_feeds(self, urls):

        # delete all urls from config
        self.config.remove_section('Feeds')
        self.config.add_section('Feeds')
        
        if not urls:
            #self.write()
            return
        
        i = 0
        feed_str = "feeds%%0%ii" % len(str(len(urls)))
        for url in urls:
            self._set('Feeds', feed_str % i, url)
            i+= 1

        

    def get_browser(self):
        return self._get('General', 'browser')
    

    def set_browser(self, browser):
        browser = browser.replace('%s', '%%s')
        self._set('General', 'browser', browser)
        
        
    def get_defaultencoding(self):
        encoding = self._get('General', 'DefaultEncoding')
        
        if encoding in valid_encodings:
            return encoding
        else:
            return 'utf-8'

    
    def set_defaultencodig(self, encoding):

        if encoding in valid_encodings:
            self._set('General', 'DefaultEncoding', encoding)            
            return True
        else:
            return False


    def get_cachesave(self):
        return self._get('General', 'CacheSave')

    def get_timeout(self):
        return int(self._get('General', 'SocketTimeout'))

    def set_timeout(self, timeout):
        self._set('General', 'SocketTimeout', str(timeout))

    def get_readsave(self):
        return self._get('General', 'ReadSave')

    def get_configdir(self):
        return self._get('General', 'ConfigDir')

    def get_cachedir(self):
        return self._get('General', 'CacheDir')
    
    def get_bozo(self):
        return bool(int(self._get('General', 'ShowBozo')))

    def set_bozo(self, flag):
        if flag:
            self._set('General', 'ShowBozo', '1')
        else:
            self._set('General', 'ShowBozo', '0')
            
