
from distutils.core import setup, Extension
from src.version import version

setup(

    name='goodnews',
    version=version,

    package_dir={'goodnews': 'src'},
    packages=['goodnews'],      
    ext_modules=[Extension('goodnews.curses_extra', sources = ['src/curses_extra.c'], libraries = ['curses'])],
    scripts=['bin/goodnews'],

    author='Stian Husemoen',
    author_email='stianh@batbelt.org',
    url='http://www.batbelt.org/goodnews',
    license='GPL',
    description='Goodnews is a simple text-only RSS reader written in Python',
    long_description="Goodnews is a very simple text-only RSS reader written in Python. Goodnews's UI a modeled after pico and pine and should be simple enough to start using without reading any documentation. Goodnews uses the excellent Universal Feed Parser module written by Mark Pilgrim to parse feeds. A copy of Universal Feed Parser is included in the distribution.",

    )




